function Posterior=BayesRegressionUpdate(Prior, y, X, dVar)
%	BAYESREGRESSIONUPDATE - Posterior=BayesRegressionUpdate(Prior, y, X, dVar)
%	Update a normal coefficient prior in the standard regression model
%	Returns Posterior.mu & Posterior.cov;
%	Posterior.ret is a return code (0=normal).

[n,m] = size(X);
if n<=m
	error('PosteriorBayesRegressionUpdate. rows(X)<=cols(x)')
end
[ny,my] = size(y);
if ny~=n
	error('PosteriorBayesRegressionUpdate. rows(y)~=rows(X)')
end

% Find the least squares solution.
[Q, R]=qr(X,0);

warning off;
try	% catch errors due to near-singular solutions
	b = R\(Q'*y);
	RI = R\eye(m);
catch
	Posterior.ret=10;
	warning on;
	return;
end
warning on;

if any(any(isinf(Prior.cov)))
	Posterior.mu = b;
	Posterior.cov = dVar*(RI'*RI);	%	(X'X)^-1 = RI' * RI
	Postrior.ret = 0;
else
	covi = Prior.cov\eye(m);
	Di = (1/dVar)*(R'*R) + covi;	%	(X'X) = R'*R
	try
		warning off;
		D = Di\eye(m);
	catch
		Posterior.ret = 1;
		Posterior.mu = b;
		Posterior.cov = dVar*(RI'*RI);
		warning on;
		return;
	end
	warning on;
	d = (1/dVar)*X'*y + covi*Prior.mu;
	Posterior.mu = D*d;
	Posterior.cov = D;
	Posterior.ret = 0;
end
